PSCAD 4.2.0

Settings
 {
 Id = "976141504.1144682885"
 Author = "jayas.jayas"
 Desc = "Parallel Line with T-Tap (Mid-line Fault)"
 Arch = "windows"
 Options = 0
 Build = 19
 Warn = 7
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 5e-005
  Plot = 5e-005
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "noname.out"
  SFile = "noname.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  f = 60.0 [Hz]
  }

 }

Definitions
 {
 Module("Controls")
  {
  Desc = ""
  FileDate = 1144682575
  Nodes = 
   {
   Output("BRKR",36,-36)
    {
    Type = Integer
    Dim  = [5]
    }
   Output("FLT",36,18)
    {
    Type = Integer
    }
   Input("FLTTYP",36,-18)
    {
    Type = Integer
    }
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Pen(Gray)
   Line(27,28,27,-43)
   Brush(,Silver)
   Rectangle(0,-13,3,0)
   Brush(,Gray)
   Rectangle(-3,-10,6,-7)
   Text(1,25,"Controls")
   Pen(Black)
   Line(27,18,36,18)
   Line(27,-36,36,-36)
   Pen(ByNode)
   Brush(Hollow)
   Rectangle(-4,-18,7,3)
   Pen(Black)
   Line(36,-18,27,-18)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   0.datalabel([1764,360],3,0,-1)
    {
    Name = "B1T2"
    }
   0.datalabel([1764,414],3,0,-1)
    {
    Name = "B2T1"
    }
   0.datalabel([1764,468],3,0,-1)
    {
    Name = "B2T2"
    }
   -Wire-([666,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([702,756],0,0,-1)
    {
    Name = "Tfs"
    }
   0.datalabel([1530,1404],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1530,1404],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([1782,684],3,0,-1)
    {
    Name = "B3T1"
    }
   0.datalabel([1782,738],3,0,-1)
    {
    Name = "B3T2"
    }
   0.datalabel([1782,792],3,0,-1)
    {
    Name = "B4T1"
    }
   -Sticky-([1458,1206],0)
    {
    Name = ""
    Font = 1
    Bounds = 1458,1206,1566,1242
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Exports to Main Page"
    }
   0.datalabel([1530,1260],6,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1530,1278],6,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([1530,1296],6,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([1530,1314],6,0,-1)
    {
    Name = "B4"
    }
   0.datalabel([1782,846],3,0,-1)
    {
    Name = "B4T2"
    }
   0.tbreakn([1908,288],4,0,20)
    {
    NUMS = "1"
    INIT = "0"
    TO1 = "B1T1"
    TO2 = "B1T2"
    }
   0.tbreakn([1926,666],4,0,280)
    {
    NUMS = "1"
    INIT = "0"
    TO1 = "B3T1"
    TO2 = "B3T2"
    }
   0.var([1728,468],0,41329408,60)
    {
    Name = "B2T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   0.var([1728,360],0,41332424,40)
    {
    Name = "B1T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   -ControlPanel-([1476,810],0)
    {
    Name = "B4 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(42563552)
    Slider(42359608)
    Slider(42571720)
    }
   0.var([1746,792],0,42359608,140)
    {
    Name = "B4T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1746,738],0,42362472,130)
    {
    Name = "B3T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1746,684],0,42365384,120)
    {
    Name = "B3T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.datalabel([1764,306],3,0,-1)
    {
    Name = "B1T1"
    }
   0.var([1728,306],0,42369136,10)
    {
    Name = "B1T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   -Wire-([1944,324],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([1944,396],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([1944,432],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([1890,378],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.logic([1980,432],6,0,250)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1980,756],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([1926,738],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1980,666],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.logic([2016,684],0,0,290)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1980,666],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.logic([2016,792],6,0,300)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1980,846],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1980,846],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.datalabel([1530,1332],6,0,-1)
    {
    Name = "B5"
    }
   0.datalabel([810,774],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([666,792],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([702,792],0,0,-1)
    {
    Name = "Tfd"
    }
   -Wire-([1944,1008],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1998,1062],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([1980,1062],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.var([1764,1008],0,42383320,190)
    {
    Name = "B5T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   0.datalabel([1800,1008],3,0,-1)
    {
    Name = "B5T1"
    }
   0.datalabel([1800,1062],3,0,-1)
    {
    Name = "B5T2"
    }
   -ControlPanel-([54,234],0)
    {
    Name = "SOURCE 1"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(43666160)
    Meter(43709344)
    Slider(43668936)
    Meter(43629976)
    Meter(43375256)
    Meter(43372160)
    Meter(43455784)
    Meter(43613152)
    }
   0.arrow_a([558,198],1,0,-1)
    {
    }
   -ControlPanel-([54,360],0)
    {
    Name = "SOURCE 2"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(43671792)
    Meter(43703520)
    Slider(43674648)
    Meter(43276088)
    Meter(43584296)
    Meter(43604384)
    Meter(43458696)
    Meter(43619008)
    }
   -ControlPanel-([306,486],0)
    {
    Name = "Bus 5"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Meter(43635880)
    Meter(43493152)
    Meter(43610240)
    }
   0.export([1584,1368],4,0,380)
    {
    Name = "BRKR"
    }
   0.export([1620,1404],4,0,370)
    {
    Name = "FLT"
    }
   0.import([1674,1296],0,0,220)
    {
    Name = "FLTTYP"
    }
   0.datalabel([1926,738],6,0,-1)
    {
    Name = "FLTTYP"
    }
   0.datalabel([1890,378],6,0,-1)
    {
    Name = "FLTTYP"
    }
   0.datalabel([1944,1008],6,0,-1)
    {
    Name = "FLTTYP"
    }
   0.tfaultn([774,774],4,0,270)
    {
    TF = "Tfs"
    DF = "Tfd"
    }
   -Wire-([864,108],0,0,-1)
    {
    Vertex="0,0;0,558"
    }
   -Sticky-([54,162],0)
    {
    Name = ""
    Font = 1
    Bounds = 54,162,180,198
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "PREFAULT CONTROLS"
    }
   -Sticky-([1476,126],0)
    {
    Name = ""
    Font = 1
    Bounds = 1476,126,1584,162
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "BREAKER CONTROLS"
    }
   -ControlPanel-([1476,396],0)
    {
    Name = "B2 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(42558112)
    Slider(42568992)
    Slider(41329408)
    }
   -ControlPanel-([1476,648],0)
    {
    Name = "B3 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(42560832)
    Slider(42365384)
    Slider(42362472)
    }
   -Sticky-([558,72],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 558,72,720,198
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust phase angle to obtain
the correct power flow. Adjust
voltage to obtain the matching
VAR flow at each end."
    }
   -Sticky-([1080,144],0)
    {
    Name = ""
    Font = 1
    Bounds = 1080,144,1188,180
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Playback Recorders"
    }
   0.tbreakn([1908,486],4,0,80)
    {
    NUMS = "1"
    INIT = "0"
    TO1 = "B2T1"
    TO2 = "B2T2"
    }
   0.tbreakn([1926,846],4,0,170)
    {
    NUMS = "1"
    INIT = "0"
    TO1 = "B4T1"
    TO2 = "B4T2"
    }
   0.datamerge([1548,1332],4,0,360)
    {
    N = "5"
    Type = "1"
    Disp = "1"
    }
   -ControlPanel-([1476,1008],0)
    {
    Name = "B5  Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(42566272)
    Slider(42383320)
    Slider(42574440)
    }
   0.logic([1980,324],0,0,240)
    {
    Type = "1"
    Inv = "0"
    }
   0.logic([2034,1008],0,0,320)
    {
    Type = "1"
    Inv = "0"
    }
   0.datalabel([2142,972],6,0,-1)
    {
    Name = "B5"
    }
   0.logic([2052,288],0,0,330)
    {
    Type = "2"
    Inv = "0"
    }
   0.datalabel([2088,288],6,0,-1)
    {
    Name = "B1"
    }
   0.logic([2052,468],6,0,260)
    {
    Type = "2"
    Inv = "0"
    }
   0.datalabel([2088,468],4,0,-1)
    {
    Name = "B2"
    }
   0.logic([2088,648],0,0,340)
    {
    Type = "2"
    Inv = "0"
    }
   0.datalabel([2124,648],2,0,-1)
    {
    Name = "B3"
    }
   0.logic([2088,828],6,0,310)
    {
    Type = "2"
    Inv = "0"
    }
   0.datalabel([2124,828],4,0,-1)
    {
    Name = "B4"
    }
   0.var_switch([1980,288],0,42555472,30)
    {
    Name = "42 B1"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.var_switch([1980,468],0,42558112,70)
    {
    Name = "42 B2"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.var_switch([2016,648],0,42560832,100)
    {
    Name = "42 B3"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.var_switch([2016,828],0,42563552,160)
    {
    Name = "42 B4"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.var_switch([2034,972],0,42566272,180)
    {
    Name = "42 B5"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.var([1728,414],0,42568992,50)
    {
    Name = "B2T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   0.var([1746,846],0,42571720,150)
    {
    Name = "B4T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1764,1062],0,42574440,200)
    {
    Name = "B5T2"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   0.pgb([1710,1296],0,42577160,230)
    {
    Name = "<Untitled>"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.logic([2106,972],0,0,350)
    {
    Type = "2"
    Inv = "0"
    }
   0.var([630,756],0,42581184,90)
    {
    Name = "Fault Start "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.2"
    Units = "s"
    Collect = "1"
    }
   0.var([630,792],0,42583960,110)
    {
    Name = "Duration "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.2"
    Units = ""
    Collect = "1"
    }
   0.tbreakn([1944,1062],4,0,210)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B5T1"
    TO2 = "B5T2"
    }
   -ControlPanel-([36,738],0)
    {
    Name = "Fault Location, Type, Start & Duration"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,432,126
    Dial(43652264)
    Dial(43649368)
    Slider(42581184)
    Slider(42583960)
    Slider(43682592)
    }
   -Sticky-([306,882],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 306,882,450,1098
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> A-g
  2=> B-g
  3=> C-g
  4=> AB-g
  5=> AC-g
  6=> BC-g
  7=> ABC-g
  8=> AB 
  9=> AC 
10=> No fault 
11=> No fault (0)"
    }
   -Sticky-([36,684],0)
    {
    Name = ""
    Font = 1
    Bounds = 36,684,144,720
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "FAULT CONTROLS"
    }
   -Sticky-([1818,126],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 1818,126,1980,198
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust breaker clearing time (T1)
and reclose time (T2) if needed."
    }
   -Sticky-([36,882],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 36,882,270,1224
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> FT1:
          Between Source and  breakers 
          (B1 and B3)
  2=> FT2: 
          Between B1 and LINE1
  3=> FT3: 
          Between LINE2 and B2
  4=> FT4: 
          Between breakers (B3 and B4)
          and Source
  5=> FT5:
          Between T3 and B3
  6=> FT6:
          Between T3 and T4
  7=> FT7:
          Between T4 and B4
  8=> FT8:
          Between B5 and load
  9=> FT9:
          Between T5 and T6"
    }
   -Sticky-([576,828],0)
    {
    Name = ""
    Font = 1
    Bounds = 576,828,918,954
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
An A to Ground fault is applied between T5 and T6, at Fault Location 9.
It occurs at 0.2 sec and has a duration of 0.2 sec.

No Breakers are set to trigger."
    }
   -ControlPanel-([1476,252],0)
    {
    Name = "B1 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(42555472)
    Slider(42369136)
    Slider(41332424)
    }
   -Wire-([1440,1170],0,0,-1)
    {
    Vertex="0,0;450,0"
    }
   -Wire-([1422,126],0,0,-1)
    {
    Vertex="0,0;0,1098"
    }
   -ControlPanel-([1080,216],0)
    {
    Name = "Recorders"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Slider(43764040)
    Slider(43272072)
    }
   -Wire-([54,666],0,0,-1)
    {
    Vertex="0,0;1368,0"
    }
   -ControlPanel-([972,360],0)
    {
    Name = "Recorder Control"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,360,126
    Switch(43782640)
    Switch(43785360)
    Switch(43788080)
    Switch(43790968)
    Switch(43793688)
    }
   -Sticky-([1008,522],0)
    {
    Name = ""
    Font = 1
    Bounds = 1008,522,1278,630
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
To turn the Recorders on, click on the switch.
On = Recorder will record data.
Off = Recorder will NOT record data.

You can turn off and  on each recorder individually."
    }
   }
  }
 Module("Plots_1")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Line(-18,-4,21,-4)
   Text(1,-28,"Plots")
   Text(1,22,"B5")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([36,54],0)
    {
    Title = "Substation B5"
    Draw = 1
    Area = [0,0,0,0]
    Posn = [36,54]
    Icon = [-1,-1]
    Extents = 0,0,1476,1116
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,1476,268],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(43505880,"V5a",0,,,)
     Curve(43595784,"V5b",1,,,)
     Curve(43508656,"V5c",2,,,)
     }
    Graph([0,268],[0,0,1476,268],"Current")
     {
     Options = 9
     Units = ""
     Curve(43511568,"I5a",0,,,)
     Curve(43514480,"I5b",1,,,)
     Curve(43517392,"I5c",2,,,)
     }
    Graph([0,536],[0,0,1476,268],"Current")
     {
     Options = 9
     Units = ""
     Curve(43520304,"I50",0,,,)
     }
    PGraph([0,804],[0,0,1476,249],"PolyGraph")
     {
     Options = 2
     Curve(43534584,"Br5a",0,,,1)
     Curve(43485224,"Br5b",1,,,1)
     Curve(43488936,"Br5c",2,,,1)
     }
    }
   }
  }
 Module("Plots_B2")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Line(-18,-4,21,-4)
   Text(1,-28,"Plots")
   Text(3,24,"B2 B4")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([36,54],0)
    {
    Title = "Plots at B2"
    Draw = 1
    Area = [0,0,720,1116]
    Posn = [36,54]
    Icon = [-1,-1]
    Extents = 0,0,720,1116
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,720,268],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(43318616,"V2a",0,,,)
     Curve(43321648,"V2b",1,,,)
     Curve(43342744,"V2c",2,,,)
     }
    Graph([0,268],[0,0,720,268],"Current")
     {
     Options = 9
     Units = ""
     Curve(43312928,"I2a",0,,,)
     Curve(43601472,"I2b",1,,,)
     Curve(43389560,"I2c",2,,,)
     }
    Graph([0,536],[0,0,720,268],"Current")
     {
     Options = 9
     Units = ""
     Curve(43386728,"I20",0,,,)
     }
    PGraph([0,804],[0,0,720,249],"PolyGraph")
     {
     Options = 2
     Curve(43331248,"Br2a",0,,,1)
     Curve(43548032,"Br2b",1,,,1)
     Curve(43545256,"Br2c",2,,,1)
     }
    }
   -Plot-([810,54],0)
    {
    Title = "Plots at B4"
    Draw = 1
    Area = [0,0,720,1116]
    Posn = [810,54]
    Icon = [-1,-1]
    Extents = 0,0,720,1116
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,720,268],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(43539696,"V4a",0,,,)
     Curve(43550976,"V4b",1,,,)
     Curve(43438416,"V4c",2,,,)
     }
    Graph([0,268],[0,0,720,268],"Current")
     {
     Options = 9
     Units = ""
     Curve(43441328,"I4a",0,,,)
     Curve(43444240,"I4b",1,,,)
     Curve(43447152,"I4c",2,,,)
     }
    Graph([0,536],[0,0,720,268],"Current")
     {
     Options = 9
     Units = ""
     Curve(43616096,"I40",0,,,)
     }
    PGraph([0,804],[0,0,720,249],"PolyGraph")
     {
     Options = 2
     Curve(43243400,"Br4a",0,,,1)
     Curve(43607464,"Br4b",1,,,1)
     Curve(43590088,"Br4c",2,,,1)
     }
    }
   }
  }
 Module("Plots_B1")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-18,-4,21,-4)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Text(1,-28,"Plots")
   Text(3,24,"B1 B3")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([18,18],0)
    {
    Title = "Plots at B3"
    Draw = 1
    Area = [0,0,738,1170]
    Posn = [18,18]
    Icon = [-1,-1]
    Extents = 0,0,738,1170
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,738,282],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(43592864,"V3a",0,,,)
     Curve(43587176,"V3b",1,,,)
     Curve(43478304,"V3c",2,,,)
     }
    Graph([0,282],[0,0,738,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(43426848,"I3a",0,,,)
     Curve(43429680,"I3b",1,,,)
     Curve(43432592,"I3c",2,,,)
     }
    Graph([0,563],[0,0,738,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(43435504,"I30",0,,,)
     }
    PGraph([0,844],[0,0,738,263],"PolyGraph")
     {
     Options = 2
     Curve(43542480,"Br3a",0,,,1)
     Curve(43450232,"Br3b",1,,,1)
     Curve(43453008,"Br3c",2,,,1)
     }
    }
   -Plot-([792,18],0)
    {
    Title = "Plots at B1"
    Draw = 1
    Area = [0,0,738,1170]
    Posn = [792,18]
    Icon = [-1,-1]
    Extents = 0,0,738,1170
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,738,282],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(43466064,"V1a",0,,,)
     Curve(43581464,"V1b",1,,,)
     Curve(43315704,"V1c",2,,,)
     }
    Graph([0,282],[0,0,738,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(43378168,"I1a",0,,,)
     Curve(43392640,"I1b",1,,,)
     Curve(43381080,"I1c",2,,,)
     }
    Graph([0,563],[0,0,738,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(43695880,"I10",0,,,)
     }
    PGraph([0,844],[0,0,738,263],"PolyGraph")
     {
     Options = 2
     Curve(43326976,"Br1a",0,,,1)
     Curve(43334784,"Br1b",1,,,1)
     Curve(43598696,"Br1c",2,,,1)
     }
    }
   }
  }
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   0.datalabel([1134,720],4,0,-1)
    {
    Name = "FT4"
    }
   0.pgb([2268,306],0,43243400,1450)
    {
    Name = "Br4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([396,1152],2,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([432,1152],2,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([468,1152],2,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([396,1332],2,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([432,1332],2,0,-1)
    {
    Name = "I2B"
    }
   0.datalabel([468,1332],2,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1782,684],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datatap([1800,720],0,0,210)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1800,756],0,0,230)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([288,1152],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([324,1152],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([360,1152],2,0,-1)
    {
    Name = "V1C"
    }
   0.datalabel([288,1332],6,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([324,1332],6,0,-1)
    {
    Name = "V2B"
    }
   0.datalabel([360,1332],6,0,-1)
    {
    Name = "V2C"
    }
   -Wire-([2232,468],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2232,432],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2232,378],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2232,342],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,504],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,468],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,432],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,144],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,180],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,216],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1944,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1944,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1944,792],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2232,144],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2232,180],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([2088,378],0,0,600)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2088,342],0,0,590)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([2088,306],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([2088,342],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([2088,378],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1800,792],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1800,756],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1800,720],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([1800,792],0,0,260)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2088,306],0,0,580)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([2070,270],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.var([162,1260],0,43272072,410)
    {
    Name = "Stop"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.5"
    Units = "s"
    Collect = "1"
    }
   0.datalabel([1854,1170],2,0,-1)
    {
    Name = "B2"
    }
   0.pgb([1854,882],0,43276088,300)
    {
    Name = "V2rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.datalabel([2016,1170],2,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([2052,1170],2,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([2088,1170],2,0,-1)
    {
    Name = "FT3"
    }
   0.datalabel([2016,1476],0,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([2052,1476],0,0,-1)
    {
    Name = "F2"
    }
   0.datalabel([2088,1476],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([1134,738],4,0,-1)
    {
    Name = "F4"
    }
   -Wire-([2106,540],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,252],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([450,702],4,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([450,720],4,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([1890,1170],2,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([1818,1170],2,0,-1)
    {
    Name = "B1"
    }
   0.datatap([1854,1170],6,0,690)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1818,1170],6,0,700)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([2160,1170],2,0,-1)
    {
    Name = "FT5"
    }
   0.datalabel([2196,1170],2,0,-1)
    {
    Name = "FT6"
    }
   0.datalabel([2124,1476],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([2196,1476],0,0,-1)
    {
    Name = "F6"
    }
   0.datalabel([666,540],0,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([666,558],0,0,-1)
    {
    Name = "F2"
    }
   0.datalabel([666,810],0,0,-1)
    {
    Name = "FT5"
    }
   -Wire-([504,630],0,0,-1)
    {
    Vertex="0,0;-144,0"
    }
   -Wire-([648,1440],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([630,1224],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([648,1260],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.recorder2_0([774,1224],0,0,980)
    {
    FName = "stn3"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "3"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.datalabel([1818,270],0,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([1818,306],0,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([1818,342],0,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([1818,558],0,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([1818,594],0,0,-1)
    {
    Name = "I2B"
    }
   0.pgb([1854,558],0,43312928,1240)
    {
    Name = "I2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.5"
    }
   0.pgb([1854,216],0,43315704,1580)
    {
    Name = "V1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "400.0"
    }
   0.pgb([1854,432],0,43318616,1350)
    {
    Name = "V2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1854,468],0,43321648,60)
    {
    Name = "V2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.datalabel([1944,144],0,0,-1)
    {
    Name = "Br1A"
    }
   0.datalabel([1944,180],0,0,-1)
    {
    Name = "Br1B"
    }
   0.datalabel([1944,216],0,0,-1)
    {
    Name = "Br1C"
    }
   0.pgb([1980,144],0,43326976,1640)
    {
    Name = "Br1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([1944,432],0,0,-1)
    {
    Name = "Br2A"
    }
   0.datalabel([1944,468],0,0,-1)
    {
    Name = "Br2B"
    }
   0.pgb([1980,432],0,43331248,1340)
    {
    Name = "Br2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([1944,270],0,0,-1)
    {
    Name = "P1"
    }
   0.pgb([1980,180],0,43334784,1600)
    {
    Name = "Br1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datatap([1800,144],0,0,550)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1800,180],0,0,560)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1782,108],2,0,-1)
    {
    Name = "V1"
    }
   0.datalabel([1818,144],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([1818,180],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([1818,468],2,0,-1)
    {
    Name = "V2B"
    }
   0.pgb([1854,504],0,43342744,80)
    {
    Name = "V2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   -Wire-([1944,342],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1944,342],0,0,-1)
    {
    Name = "S1W"
    }
   -Wire-([1944,378],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1944,378],0,0,-1)
    {
    Name = "S1Q"
    }
   -Wire-([1944,630],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1944,666],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1944,666],0,0,-1)
    {
    Name = "S2Q"
    }
   0.datalabel([1818,432],2,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([1944,630],0,0,-1)
    {
    Name = "S2W"
    }
   -Wire-([1944,594],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1944,594],0,0,-1)
    {
    Name = "Q2"
    }
   -Wire-([1944,558],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1944,558],0,0,-1)
    {
    Name = "P2"
    }
   -Wire-([1944,504],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1944,468],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1944,432],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1944,504],0,0,-1)
    {
    Name = "Br2C"
    }
   0.datalabel([1818,630],0,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1818,630],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1818,594],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1818,558],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1818,270],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1818,306],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1818,342],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1944,144],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1944,180],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1944,216],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1944,270],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1944,306],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1818,504],2,0,-1)
    {
    Name = "V2C"
    }
   0.datatap([1800,504],0,0,70)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1800,468],0,0,50)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1800,432],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1800,468],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1800,504],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([1818,216],2,0,-1)
    {
    Name = "V1C"
    }
   -Wire-([1800,216],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1800,180],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1800,144],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([1800,216],0,0,570)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1944,306],0,0,-1)
    {
    Name = "Q1"
    }
   0.datatap([1800,432],0,0,610)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1782,396],2,0,-1)
    {
    Name = "V2"
    }
   -Wire-([1782,396],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pgb([1980,306],0,43372160,1480)
    {
    Name = "Q1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([1980,270],0,43375256,1500)
    {
    Name = "P1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1854,270],0,43378168,1520)
    {
    Name = "I1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "4.0"
    }
   0.pgb([1854,342],0,43381080,1460)
    {
    Name = "I1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "4.0"
    }
   -Wire-([1818,666],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1818,378],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1818,666],0,0,-1)
    {
    Name = "I20"
    }
   0.pgb([1854,666],0,43386728,1150)
    {
    Name = "I20"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.6"
    Max = "1.0"
    }
   0.pgb([1854,630],0,43389560,1180)
    {
    Name = "I2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.5"
    }
   0.pgb([1854,306],0,43392640,1490)
    {
    Name = "I1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "4.0"
    }
   -Wire-([1782,108],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([1818,378],0,0,-1)
    {
    Name = "I10"
    }
   0.datalabel([1782,684],2,0,-1)
    {
    Name = "V3"
    }
   0.datalabel([1818,720],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([1818,756],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([1818,792],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([2106,306],2,0,-1)
    {
    Name = "V4A"
    }
   0.datalabel([2106,342],2,0,-1)
    {
    Name = "V4B"
    }
   0.datalabel([2106,378],2,0,-1)
    {
    Name = "V4C"
    }
   0.datalabel([702,1152],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([738,1152],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([774,1152],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([702,1332],6,0,-1)
    {
    Name = "V4A"
    }
   0.datalabel([738,1332],6,0,-1)
    {
    Name = "V4B"
    }
   0.datalabel([774,1332],6,0,-1)
    {
    Name = "V4C"
    }
   0.datalabel([2106,144],0,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([2106,180],0,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([2106,216],0,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([2106,432],0,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([2106,468],0,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([2106,504],0,0,-1)
    {
    Name = "I4C"
    }
   0.datalabel([2106,540],0,0,-1)
    {
    Name = "I40"
    }
   0.datalabel([810,1152],2,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([846,1152],2,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([882,1152],2,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([810,1332],2,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([846,1332],2,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([882,1332],2,0,-1)
    {
    Name = "I4C"
    }
   0.datalabel([468,1296],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([468,1476],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([2232,144],0,0,-1)
    {
    Name = "P3"
    }
   0.datalabel([2232,180],0,0,-1)
    {
    Name = "Q3"
    }
   0.datalabel([1944,720],0,0,-1)
    {
    Name = "Br3A"
    }
   0.datalabel([1944,756],0,0,-1)
    {
    Name = "Br3B"
    }
   0.datalabel([1944,792],0,0,-1)
    {
    Name = "Br3C"
    }
   -Wire-([2232,306],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2232,306],0,0,-1)
    {
    Name = "Br4A"
    }
   0.datalabel([2232,342],0,0,-1)
    {
    Name = "Br4B"
    }
   0.datalabel([2232,378],0,0,-1)
    {
    Name = "Br4C"
    }
   0.datalabel([2232,432],0,0,-1)
    {
    Name = "P4"
    }
   0.datalabel([2232,468],0,0,-1)
    {
    Name = "Q4"
    }
   0.pgb([2142,144],0,43426848,1630)
    {
    Name = "I3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.6"
    Max = "0.6"
    }
   0.pgb([2142,180],0,43429680,1590)
    {
    Name = "I3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.6"
    Max = "0.6"
    }
   0.pgb([2142,216],0,43432592,1540)
    {
    Name = "I3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.6"
    Max = "0.6"
    }
   0.pgb([2142,252],0,43435504,1510)
    {
    Name = "I30"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.01"
    Max = "0.02"
    }
   0.pgb([2142,378],0,43438416,1380)
    {
    Name = "V4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([2142,432],0,43441328,1330)
    {
    Name = "I4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.8"
    Max = "0.8"
    }
   0.pgb([2142,468],0,43444240,1290)
    {
    Name = "I4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.8"
    Max = "0.8"
    }
   0.pgb([2142,504],0,43447152,1260)
    {
    Name = "I4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.8"
    Max = "0.8"
    }
   0.pgb([1980,756],0,43450232,1050)
    {
    Name = "Br3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1980,792],0,43453008,1020)
    {
    Name = "Br3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([2268,144],0,43455784,1610)
    {
    Name = "P3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([2268,432],0,43458696,1320)
    {
    Name = "P4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.datalabel([666,828],0,0,-1)
    {
    Name = "F5"
    }
   0.datalabel([1926,1170],2,0,-1)
    {
    Name = "B4"
    }
   0.breaker3([540,792],4,0,720)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B3"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I3A"
    IBRB = "I3B"
    IBRC = "I3C"
    IBR0 = "I30"
    SBRA = "Br3A"
    SBRB = "Br3B"
    SBRC = "Br3C"
    BP = "P3"
    BQ = "Q3"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "-90.35"
    Q = "211.3"
    }
   0.pgb([1854,144],0,43466064,1650)
    {
    Name = "V1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "400.0"
    }
   0.pgb([1854,918],0,43469032,310)
    {
    Name = "V3rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.datatap([1926,1170],6,0,670)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.breaker3([1044,792],0,0,710)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B4"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I4A"
    IBRB = "I4B"
    IBRC = "I4C"
    IBR0 = "I40"
    SBRA = "Br4A"
    SBRB = "Br4B"
    SBRC = "Br4C"
    BP = "P4"
    BQ = "Q4"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "94.27"
    Q = "-216.8"
    }
   0.datalabel([1962,1170],2,0,-1)
    {
    Name = "B5"
    }
   0.datatap([1962,1170],6,0,660)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   -Wire-([468,666],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.pgb([1854,792],0,43478304,270)
    {
    Name = "V3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "400.0"
    }
   -Wire-([2232,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2232,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2232,666],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2232,630],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2232,594],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2232,594],0,0,-1)
    {
    Name = "Br5A"
    }
   0.datalabel([2232,630],0,0,-1)
    {
    Name = "Br5B"
    }
   0.pgb([2268,630],0,43485224,1130)
    {
    Name = "Br5b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([2232,666],0,0,-1)
    {
    Name = "Br5C"
    }
   0.pgb([2268,666],0,43488936,1090)
    {
    Name = "Br5c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([2232,720],0,0,-1)
    {
    Name = "P5"
    }
   0.datalabel([2232,756],0,0,-1)
    {
    Name = "Q5"
    }
   0.pgb([2268,720],0,43493152,1060)
    {
    Name = "P5"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   -Wire-([2070,558],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datatap([2088,594],0,0,110)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2088,630],0,0,150)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([2106,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2106,792],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2088,666],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([2088,630],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([2088,594],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([2088,666],0,0,180)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([2106,828],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2070,558],2,0,-1)
    {
    Name = "V5"
    }
   0.datalabel([2106,594],2,0,-1)
    {
    Name = "V5A"
    }
   0.datalabel([2106,630],2,0,-1)
    {
    Name = "V5B"
    }
   0.datalabel([2106,666],2,0,-1)
    {
    Name = "V5C"
    }
   0.pgb([2142,594],0,43505880,120)
    {
    Name = "V5a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-30.0"
    Max = "30.0"
    }
   0.pgb([2142,666],0,43508656,190)
    {
    Name = "V5c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-30.0"
    Max = "30.0"
    }
   0.pgb([2142,720],0,43511568,1070)
    {
    Name = "I5a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.5"
    Max = "2.5"
    }
   0.pgb([2142,756],0,43514480,1040)
    {
    Name = "I5b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.5"
    Max = "2.5"
    }
   0.pgb([2142,792],0,43517392,1010)
    {
    Name = "I5c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.5"
    Max = "2.5"
    }
   0.pgb([2142,828],0,43520304,1000)
    {
    Name = "I50"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.0e-009"
    Max = "1.0e-009"
    }
   0.datalabel([2106,828],0,0,-1)
    {
    Name = "I50"
    }
   0.datalabel([2106,792],0,0,-1)
    {
    Name = "I5C"
    }
   0.datalabel([2106,756],0,0,-1)
    {
    Name = "I5B"
    }
   0.datalabel([2106,720],0,0,-1)
    {
    Name = "I5A"
    }
   0.datalabel([882,1296],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1350,1296],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([882,1476],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1350,1152],2,0,-1)
    {
    Name = "I5C"
    }
   0.datalabel([1314,1152],2,0,-1)
    {
    Name = "I5B"
    }
   0.datalabel([1278,1152],2,0,-1)
    {
    Name = "I5A"
    }
   0.datalabel([1242,1152],6,0,-1)
    {
    Name = "V5C"
    }
   0.datalabel([1206,1152],6,0,-1)
    {
    Name = "V5B"
    }
   0.datalabel([1170,1152],6,0,-1)
    {
    Name = "V5A"
    }
   0.pgb([2268,594],0,43534584,1170)
    {
    Name = "Br5a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([2232,1170],6,0,-1)
    {
    Name = "FT7"
    }
   0.datalabel([2232,1476],4,0,-1)
    {
    Name = "F7"
    }
   0.datalabel([2070,270],2,0,-1)
    {
    Name = "V4"
    }
   0.pgb([2142,306],0,43539696,1470)
    {
    Name = "V4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1980,720],0,43542480,1080)
    {
    Name = "Br3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1980,504],0,43545256,1270)
    {
    Name = "Br2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1980,468],0,43548032,1300)
    {
    Name = "Br2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([2142,342],0,43550976,1430)
    {
    Name = "V4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.datatap([2016,1170],6,0,960)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2052,1170],6,0,950)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2088,1170],6,0,940)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2124,1170],6,0,930)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2196,1170],6,0,910)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2232,1170],6,0,900)
    {
    Index = "7"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   -Wire-([2106,1260],0,0,-1)
    {
    Vertex="0,0;0,126"
    }
   -Wire-([2142,1350],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.datalabel([2142,1296],0,0,-1)
    {
    Name = "Faulttype"
    }
   -Wire-([2142,1260],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([2178,1296],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.datalabel([2142,1350],2,0,-1)
    {
    Name = "Fault"
    }
   0.datatap([2052,1476],0,0,830)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2088,1476],0,0,820)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2124,1476],0,0,810)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2160,1476],0,0,800)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2196,1476],0,0,790)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([2124,1170],2,0,-1)
    {
    Name = "FT4"
    }
   0.recorder2_0([360,1224],0,0,990)
    {
    FName = "stn1"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "1"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.mux_array([2124,1224],0,0,870)
    {
    DPath = "0"
    }
   0.pgb([1854,180],0,43581464,1620)
    {
    Name = "V1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "400.0"
    }
   0.pgb([1980,558],0,43584296,1220)
    {
    Name = "P2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1854,756],0,43587176,240)
    {
    Name = "V3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "400.0"
    }
   0.pgb([2268,378],0,43590088,1370)
    {
    Name = "Br4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1854,720],0,43592864,220)
    {
    Name = "V3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "400.0"
    }
   0.pgb([2142,630],0,43595784,160)
    {
    Name = "V5b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-30.0"
    Max = "30.0"
    }
   0.pgb([1980,216],0,43598696,1550)
    {
    Name = "Br1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1854,594],0,43601472,1210)
    {
    Name = "I2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.5"
    }
   0.pgb([1980,594],0,43604384,1200)
    {
    Name = "Q2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([2268,342],0,43607464,1410)
    {
    Name = "Br4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([2268,756],0,43610240,1030)
    {
    Name = "Q5"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([2268,180],0,43613152,1570)
    {
    Name = "Q3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([2142,540],0,43616096,1230)
    {
    Name = "I40"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.01"
    Max = "0.02"
    }
   0.pgb([2268,468],0,43619008,1280)
    {
    Name = "Q4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   -Sticky-([1836,90],0)
    {
    Name = ""
    Font = 1
    Bounds = 1836,90,1944,126
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "OUTPUT CHANNELS"
    }
   -Wire-([234,1440],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([234,1260],0,0,-1)
    {
    Vertex="0,0;0,288"
    }
   -Wire-([648,1260],0,0,-1)
    {
    Vertex="0,0;0,288"
    }
   0.datatap([1890,1170],6,0,680)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1782,1188],0,0,-1)
    {
    Name = "Breaker"
    }
   0.datatap([2016,1476],0,0,840)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.breaker3([540,522],4,0,740)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B1"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I1A"
    IBRB = "I1B"
    IBRC = "I1C"
    IBR0 = "I10"
    SBRA = "Br1A"
    SBRB = "Br1B"
    SBRC = "Br1C"
    BP = "P1"
    BQ = "Q1"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "-49.66"
    Q = "233.4"
    }
   -Wire-([1080,630],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.pgb([1854,846],0,43629976,290)
    {
    Name = "V1rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.pgb([1854,954],0,43632968,330)
    {
    Name = "V4rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.pgb([1854,990],0,43635880,350)
    {
    Name = "V5rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "20"
    Max = "27"
    }
   -Wire-([1116,666],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([1080,666],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([468,666],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([756,810],0,0,-1)
    {
    Name = "FT6"
    }
   0.datalabel([756,828],0,0,-1)
    {
    Name = "F6"
    }
   0.datalabel([918,810],0,0,-1)
    {
    Name = "FT7"
    }
   0.datalabel([918,828],0,0,-1)
    {
    Name = "F7"
    }
   0.datalabel([1260,342],0,0,-1)
    {
    Name = "FT8"
    }
   0.datalabel([1260,360],0,0,-1)
    {
    Name = "F8"
    }
   0.datalabel([2268,1170],6,0,-1)
    {
    Name = "FT8"
    }
   0.datatap([2268,1170],6,0,890)
    {
    Index = "8"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2160,1170],6,0,920)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([2160,1476],0,0,-1)
    {
    Name = "F5"
    }
   0.mux_array([2124,1422],6,0,650)
    {
    DPath = "0"
    }
   0.var_pot([2250,1296],2,43649368,530)
    {
    Name = "Fault Type"
    Group = ""
    Display = "0"
    NDP = "10"
    Value = "1"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "0"
    }
   0.var_pot([2034,1314],0,43652264,520)
    {
    Name = "Fault location"
    Group = ""
    Display = "0"
    NDP = "9"
    Value = "9"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "10.0"
    }
   0.unity([2178,1296],4,0,630)
    {
    IType = "2"
    OType = "1"
    }
   0.unity([2106,1314],0,0,540)
    {
    IType = "2"
    OType = "1"
    }
   0.resistive_load([1332,324],0,0,-1)
    {
    P = "40.0 [MW]"
    V = "24.0 [kV]"
    SD = "0"
    }
   0.reactive_load([1422,324],0,0,-1)
    {
    S = "10.0 [MVAR]"
    V = "24.0 [kV]"
    F = "$(f)"
    SD = "0"
    }
   -Wire-([1998,1458],0,0,-1)
    {
    Vertex="0,0;324,0"
    }
   0.datalabel([2268,1476],4,0,-1)
    {
    Name = "F8"
    }
   0.datatap([2268,1476],0,0,770)
    {
    Index = "8"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2304,1476],0,0,760)
    {
    Index = "9"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([2304,1476],4,0,-1)
    {
    Name = "F9"
    }
   0.datatap([2304,1170],6,0,880)
    {
    Index = "9"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1998,1188],0,0,-1)
    {
    Vertex="0,0;288,0"
    }
   0.datalabel([2304,1170],6,0,-1)
    {
    Name = "FT9"
    }
   0.datalabel([2106,252],0,0,-1)
    {
    Name = "I30"
    }
   0.var([342,702],3,43666160,100)
    {
    Name = "Ph Angle"
    Group = "SS1"
    Display = "0"
    Max = "180"
    Min = "0.0"
    Value = "0.0"
    Units = "deg"
    Collect = "1"
    }
   0.var([288,702],3,43668936,90)
    {
    Name = "Voltage"
    Group = "SS1"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "400.0"
    Units = "kV"
    Collect = "1"
    }
   0.var([1206,702],5,43671792,130)
    {
    Name = "Ph Angle"
    Group = "SS2"
    Display = "0"
    Max = "180"
    Min = "-180"
    Value = "20.4"
    Units = "deg"
    Collect = "1"
    }
   0.var([1260,702],5,43674648,140)
    {
    Name = "Voltage"
    Group = "SS2"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "240.0"
    Units = "kV"
    Collect = "1"
    }
   0.source3R([324,630],6,0,1310)
    {
    Name = "Source1"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S1W"
    Q = "S1Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.source3R([1224,630],2,0,620)
    {
    Name = "Source2"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S2W"
    Q = "S2Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.datalabel([1926,1278],0,0,-1)
    {
    Name = "Ron"
    }
   0.var([1818,1278],0,43682592,500)
    {
    Name = "Rf"
    Group = ""
    Display = "0"
    Max = "50"
    Min = "0.001"
    Value = "0.001"
    Units = "ohm"
    Collect = "1"
    }
   0.tpflt([1224,324],0,0,1530)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([1098,702],0,0,1190)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([954,792],4,0,1100)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([792,792],4,0,1110)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([630,792],0,0,1140)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([486,684],4,0,1250)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.annotation([1818,1260],0,0,-1)
    {
    AL1 = "Rf"
    AL2 = ""
    }
   0.pgb([1854,378],0,43695880,1420)
    {
    Name = "I10"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.6"
    Max = "1.0"
    }
   0.datalabel([882,540],0,0,-1)
    {
    Name = "FT3"
    }
   0.datalabel([882,558],0,0,-1)
    {
    Name = "F3"
    }
   0.pgb([1980,666],0,43700744,1120)
    {
    Name = "QS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([1980,630],0,43703520,1160)
    {
    Name = "PS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1980,378],0,43706432,1400)
    {
    Name = "QS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([1980,342],0,43709344,1440)
    {
    Name = "PS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   -Wire-([1224,324],0,0,-1)
    {
    Vertex="0,0;198,0"
    }
   -Bus-([774,288],0,113110160,-1)
    {
    P1 = [0,0]
    P2 = [0,270]
    I = 1
    NAME = BUS3
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   -Bus-([504,486],0,113110704,-1)
    {
    P1 = [0,0]
    P2 = [0,342]
    I = 1
    NAME = BUS1
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   -Bus-([1080,486],0,52442224,-1)
    {
    P1 = [0,0]
    P2 = [0,342]
    I = 1
    NAME = BUS2
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   0.breaker3([1044,522],0,0,730)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B2"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I2A"
    IBRB = "I2B"
    IBRC = "I2C"
    IBR0 = "I20"
    SBRA = "Br2A"
    SBRB = "Br2B"
    SBRC = "Br2C"
    BP = "P2"
    BQ = "Q2"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "129.7"
    Q = "-195"
    }
   0.datalabel([1440,972],4,0,-1)
    {
    Name = "Faulttype"
    }
   0.datalabel([1440,954],4,0,-1)
    {
    Name = "Breaker"
    }
   -Sticky-([828,180],0)
    {
    Name = ""
    Font = 1
    Bounds = 828,180,918,216
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION  3"
    }
   -Sticky-([1332,594],0)
    {
    Name = ""
    Font = 1
    Bounds = 1332,594,1548,702
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Default is 0.1 pu or 52.9 ohm positive
sequence, 0.1 pu zero sequence.
See instruction manual Section 3.2.1  for 
details on  changing the source impedance."
    }
   0.arrow_s([1332,630],1,0,-1)
    {
    }
   0.tpflt([900,324],4,0,1560)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.datalabel([864,342],0,0,-1)
    {
    Name = "FT9"
    }
   0.datalabel([864,360],0,0,-1)
    {
    Name = "F9"
    }
   .Plots_B1([540,900],0,0,250)
    {
    }
   .Plots_B2([1044,900],0,0,280)
    {
    }
   .Plots_1([972,216],0,0,10)
    {
    }
   0.datatap([2232,1476],0,0,780)
    {
    Index = "7"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1944,1188],0,0,-1)
    {
    Vertex="0,0;-162,0"
    }
   -Wire-([1854,1278],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.recorder2_0([1242,1224],0,0,970)
    {
    FName = "stn5"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "5"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.recorder2_0([774,1404],0,0,850)
    {
    FName = "stn4"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "4"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.recorder2_0([360,1404],0,0,860)
    {
    FName = "stn2"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "2"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.var([18,1116],0,43764040,320)
    {
    Name = "Start"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.15"
    Units = "s"
    Collect = "1"
    }
   -Wire-([198,1260],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1134,1260],0,0,-1)
    {
    Vertex="0,0;0,288"
    }
   -Wire-([234,1548],0,0,-1)
    {
    Vertex="0,0;900,0"
    }
   -Wire-([54,1116],0,0,-1)
    {
    Vertex="0,0;918,0"
    }
   0.const([90,1188],1,0,360)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([126,1224],6,0,380)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.const([90,1368],1,0,460)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([126,1404],6,0,480)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.const([558,1188],1,0,390)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([594,1224],6,0,420)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.const([558,1368],1,0,490)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([594,1404],6,0,510)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.const([1026,1188],1,0,430)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([1062,1224],6,0,440)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([972,1116],0,0,-1)
    {
    Vertex="0,0;0,144"
    }
   -Wire-([1098,1224],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([972,1260],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([522,1116],0,0,-1)
    {
    Vertex="0,0;0,324"
    }
   -Wire-([630,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([522,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([522,1260],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([54,1116],0,0,-1)
    {
    Vertex="0,0;0,324"
    }
   -Wire-([162,1404],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([162,1224],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([54,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([54,1260],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([126,1152],1,43782640,340)
    {
    Name = "en Record1"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([126,1332],1,43785360,450)
    {
    Name = "en Record2"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([594,1152],1,43788080,370)
    {
    Name = "en Record3"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([594,1332],1,43790968,470)
    {
    Name = "en Record4"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([1062,1152],1,43793688,400)
    {
    Name = "en Record5"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.datalabel([1440,1008],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1566,1008],0,0,-1)
    {
    Vertex="0,0;-126,0"
    }
   -Wire-([1440,972],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([1566,954],0,0,-1)
    {
    Vertex="0,0;-126,0"
    }
   -TLine-([774,522],0,123087688,-1)
    {
    Name = "LINE2"
    Date = 1144682576
    Freq = "f"
    Length = "50"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;90,0;108,0"
    PageLayer(A/A4,Landscape,16,[597,467],100)
     {
     0.Line_Ground([630,702],0,23031464,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.Line_FrePhase_Options([216,468],0,44385424,-1)
      {
      Interp1 = "1"
      Output = "0"
      Inflen = "0"
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      Numf = "100"
      YMaxP = "20"
      AMaxP = "20"
      YMaxE = "2 [%]"
      AMaxE = "2 [%]"
      xxx = ""
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      }
     0.SequenceInfo([522,198],0,44386080,-1)
      {
      Mode = "0"
      X1 = "1.60304527"
      Y1 = "0.0004239421645"
      X2 = "0.0"
      Y2 = "0.0"
      X3 = "1.6031933"
      Y3 = "0.002255428195"
      X4 = "5.0e-006"
      Y4 = "2.725982885e-009"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "5.0e-006"
      Y6 = "1.93555082e-009"
      M1 = "1.60304532606"
      P1 = "0.0151524705333"
      M2 = "0.0"
      P2 = "0.0"
      M3 = "1.60319488651"
      P3 = "0.0806056458158"
      M4 = "5.0000007431e-006"
      P4 = "0.0312374597721"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "5.00000037464e-006"
      P6 = "0.0221797774959"
      }
     0.Line_Tower_3_Delta([810,612],0,76530216,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "C:\\home\\user\\pscad\\lineconstants\\database\\acsr.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "C:\\home\\user\\pscad\\lineconstants\\database\\gw.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     }
    }
   -TLine-([666,522],0,76531976,-1)
    {
    Name = "LINE1"
    Date = 1144682577
    Freq = "f"
    Length = "50"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;90,0;108,0"
    PageLayer(A/A4,Landscape,16,[597,467],100)
     {
     0.Line_Ground([630,702],0,78115256,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.Line_FrePhase_Options([216,468],0,78116064,-1)
      {
      Interp1 = "1"
      Output = "0"
      Inflen = "0"
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      Numf = "100"
      YMaxP = "20"
      AMaxP = "20"
      YMaxE = "2 [%]"
      AMaxE = "2 [%]"
      xxx = ""
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      }
     0.SequenceInfo([522,198],0,78116600,-1)
      {
      Mode = "0"
      X1 = "1.60304527"
      Y1 = "0.0004239421645"
      X2 = "0.0"
      Y2 = "0.0"
      X3 = "1.6031933"
      Y3 = "0.002255428195"
      X4 = "5.0e-006"
      Y4 = "2.725982885e-009"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "5.0e-006"
      Y6 = "1.93555082e-009"
      M1 = "1.60304532606"
      P1 = "0.0151524705333"
      M2 = "0.0"
      P2 = "0.0"
      M3 = "1.60319488651"
      P3 = "0.0806056458158"
      M4 = "5.0000007431e-006"
      P4 = "0.0312374597721"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "5.00000037464e-006"
      P6 = "0.0221797774959"
      }
     0.Line_Tower_3_Delta([810,612],0,78117624,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "C:\\home\\user\\pscad\\lineconstants\\database\\acsr.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "C:\\home\\user\\pscad\\lineconstants\\database\\gw.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     }
    }
   -TLine-([774,792],0,74760680,-1)
    {
    Name = "T4"
    Date = 1144682577
    Freq = "f"
    Length = "50.0"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;90,0;108,0"
    PageLayer(A/A4,Landscape,16,[597,467],100)
     {
     0.Line_Ground([630,702],0,74761824,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.Line_FrePhase_Options([216,468],0,74762888,-1)
      {
      Interp1 = "1"
      Output = "0"
      Inflen = "0"
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      Numf = "100"
      YMaxP = "20"
      AMaxP = "20"
      YMaxE = "2 [%]"
      AMaxE = "2 [%]"
      xxx = ""
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      }
     0.SequenceInfo([522,198],0,74763488,-1)
      {
      Mode = "0"
      X1 = "1.60304527"
      Y1 = "0.0004239421645"
      X2 = "0.0"
      Y2 = "0.0"
      X3 = "1.6031933"
      Y3 = "0.002255428195"
      X4 = "5.0e-006"
      Y4 = "2.725982885e-009"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "5.0e-006"
      Y6 = "1.93555082e-009"
      M1 = "1.60304532606"
      P1 = "0.0151524705333"
      M2 = "0.0"
      P2 = "0.0"
      M3 = "1.60319488651"
      P3 = "0.0806056458158"
      M4 = "5.0000007431e-006"
      P4 = "0.0312374597721"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "5.00000037464e-006"
      P6 = "0.0221797774959"
      }
     0.Line_Tower_3_Delta([810,612],0,100205176,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "C:\\home\\user\\pscad\\lineconstants\\database\\acsr.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "C:\\home\\user\\pscad\\lineconstants\\database\\gw.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     }
    }
   -TLine-([666,792],0,100206968,-1)
    {
    Name = "T3"
    Date = 1144682578
    Freq = "f"
    Length = "50.0"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;90,0;108,0"
    PageLayer(A/A4,Landscape,16,[597,467],100)
     {
     0.Line_Ground([630,702],0,79896584,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.Line_FrePhase_Options([216,468],0,79897424,-1)
      {
      Interp1 = "1"
      Output = "0"
      Inflen = "0"
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      Numf = "100"
      YMaxP = "20"
      AMaxP = "20"
      YMaxE = "2 [%]"
      AMaxE = "2 [%]"
      xxx = ""
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      }
     0.SequenceInfo([522,198],0,79898008,-1)
      {
      Mode = "0"
      X1 = "1.60304527"
      Y1 = "0.0004239421645"
      X2 = "0.0"
      Y2 = "0.0"
      X3 = "1.6031933"
      Y3 = "0.002255428195"
      X4 = "5.0e-006"
      Y4 = "2.725982885e-009"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "5.0e-006"
      Y6 = "1.93555082e-009"
      M1 = "1.60304532606"
      P1 = "0.0151524705333"
      M2 = "0.0"
      P2 = "0.0"
      M3 = "1.60319488651"
      P3 = "0.0806056458158"
      M4 = "5.0000007431e-006"
      P4 = "0.0312374597721"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "5.00000037464e-006"
      P6 = "0.0221797774959"
      }
     0.Line_Tower_3_Delta([810,612],0,79899032,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "C:\\home\\user\\pscad\\lineconstants\\database\\acsr.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "C:\\home\\user\\pscad\\lineconstants\\database\\gw.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     }
    }
   0.xfmr-3p2w([1044,324],0,0,-1)
    {
    Name = "Trans 1 "
    Tmva = "50.0 [MVA]"
    f = "$(f)"
    YD1 = "1"
    YD2 = "0"
    Lead = "1"
    Xl = "0.1 [pu]"
    Ideal = "0"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Tap = "0"
    View = "1"
    Dtls = "0"
    V1 = "230.0 [kV]"
    V2 = "25 [kV]"
    Enab = "1"
    Sat = "1"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0.1 [s]"
    Im1 = "1 [%]"
    ILA1 = ""
    ILB1 = ""
    ILC1 = ""
    IAB1 = ""
    IBC1 = ""
    ICA1 = ""
    ILA2 = ""
    ILB2 = ""
    ILC2 = ""
    IAB2 = ""
    IBC2 = ""
    ICA2 = ""
    IMA = ""
    IMB = ""
    IMC = ""
    FLXA = ""
    FLXB = ""
    FLXC = ""
    IMAB = ""
    IMBC = ""
    IMCA = ""
    FLXAB = ""
    FLXBC = ""
    FLXCA = ""
    }
   0.ground([1044,360],1,0,-1)
    {
    }
   -TLine-([990,324],0,109803648,-1)
    {
    Name = "T6"
    Date = 1144682578
    Freq = "f"
    Length = "50"
    Dim = 3
    Mode = 1
    Vertex="0,0;-18,0;-90,0;-108,0"
    PageLayer(A/A4,Landscape,16,[597,467],100)
     {
     0.Line_Ground([630,702],0,45639336,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.Line_FrePhase_Options([216,468],0,45640280,-1)
      {
      Interp1 = "1"
      Output = "0"
      Inflen = "0"
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      Numf = "100"
      YMaxP = "20"
      AMaxP = "20"
      YMaxE = "2 [%]"
      AMaxE = "2 [%]"
      xxx = ""
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      }
     0.SequenceInfo([522,198],0,23028152,-1)
      {
      Mode = "0"
      X1 = "1.60304527"
      Y1 = "0.0004239421645"
      X2 = "0.0"
      Y2 = "0.0"
      X3 = "1.6031933"
      Y3 = "0.002255428195"
      X4 = "5.0e-006"
      Y4 = "2.725982885e-009"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "5.0e-006"
      Y6 = "1.93555082e-009"
      M1 = "1.60304532606"
      P1 = "0.0151524705333"
      M2 = "0.0"
      P2 = "0.0"
      M3 = "1.60319488651"
      P3 = "0.0806056458158"
      M4 = "5.0000007431e-006"
      P4 = "0.0312374597721"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "5.00000037464e-006"
      P6 = "0.0221797774959"
      }
     0.Line_Tower_3_Delta([810,612],0,23028904,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "C:\\home\\user\\pscad\\lineconstants\\database\\acsr.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "C:\\home\\user\\pscad\\lineconstants\\database\\gw.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     }
    }
   -TLine-([882,324],0,74282312,-1)
    {
    Name = "T5"
    Date = 1144682579
    Freq = "f"
    Length = "50"
    Dim = 3
    Mode = 1
    Vertex="0,0;-18,0;-90,0;-108,0"
    PageLayer(A/A4,Landscape,16,[597,467],100)
     {
     0.Line_Ground([630,702],0,74283704,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.Line_FrePhase_Options([216,468],0,74284664,-1)
      {
      Interp1 = "1"
      Output = "0"
      Inflen = "0"
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      Numf = "100"
      YMaxP = "20"
      AMaxP = "20"
      YMaxE = "2 [%]"
      AMaxE = "2 [%]"
      xxx = ""
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      }
     0.SequenceInfo([522,198],0,87171280,-1)
      {
      Mode = "0"
      X1 = "1.60304527"
      Y1 = "0.0004239421645"
      X2 = "0.0"
      Y2 = "0.0"
      X3 = "1.6031933"
      Y3 = "0.002255428195"
      X4 = "5.0e-006"
      Y4 = "2.725982885e-009"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "5.0e-006"
      Y6 = "1.93555082e-009"
      M1 = "1.60304532606"
      P1 = "0.0151524705333"
      M2 = "0.0"
      P2 = "0.0"
      M3 = "1.60319488651"
      P3 = "0.0806056458158"
      M4 = "5.0000007431e-006"
      P4 = "0.0312374597721"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "5.00000037464e-006"
      P6 = "0.0221797774959"
      }
     0.Line_Tower_3_Delta([810,612],0,87172304,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "C:\\home\\user\\pscad\\lineconstants\\database\\acsr.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "C:\\home\\user\\pscad\\lineconstants\\database\\gw.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     }
    }
   0.tpflt([918,522],4,0,1360)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   -Wire-([972,792],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([612,792],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.tpflt([630,522],0,0,1390)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   -Wire-([612,522],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Sticky-([270,522],0)
    {
    Name = ""
    Font = 1
    Bounds = 270,522,360,558
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 1"
    }
   -Sticky-([1170,522],0)
    {
    Name = ""
    Font = 1
    Bounds = 1170,522,1260,558
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 2"
    }
   -Wire-([1080,324],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.breaker3([1152,324],4,0,750)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B5"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I5A"
    IBRB = "I5B"
    IBRC = "I5C"
    IBR0 = "I50"
    SBRA = "Br5A"
    SBRB = "Br5B"
    SBRC = "Br5C"
    BP = "P5"
    BQ = "Q5"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "73.56"
    Q = "18.21"
    }
   .Controls([1602,990],4,0,640)
    {
    }
   -Sticky-([36,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 36,36,684,342
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Case Description:  DOUBLE LINE WITH A T-TAP
- Two Thevinen Impedance sources connected via
   transmission lines and a T-tap.
- One transmission line terminated with a transformer
  of configurable size and type.
- System voltage is 230kV settable via source equivalents.
- Simulates three substations connected via four transmission lines.
- Nine fault positions for full fault control ahead and behind station relays.
- Faults can be placed Midline on Line 1, Line2 and Line 3
- User  must take Care to ensure the sum of the sections, T1 through T6 sum
   to the length of the lines they are simulating.
- Five breakers are independently timed controlled. (Default is closed).
- Independent breaker pole tripping is possible."
    }
   -Divider-([18,1044],0)
    {
    Size(2358,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1656,36],0)
    {
    Size(0,1494)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Sticky-([792,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 792,36,1188,144
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
This case uses global substitutions.  To change between 50Hz/60Hz. select Global Substitutions (Ctrl-G).  In the pop-up window, change the value of f to the desired frequency.
"
    }
   -Wire-([972,522],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   0.multimeter([594,522],0,0,30)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V1"
    P = ""
    Q = ""
    Vrms = "V1rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([594,792],0,0,170)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V3"
    P = ""
    Q = ""
    Vrms = "V3rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([990,792],4,0,200)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V4"
    P = ""
    Q = ""
    Vrms = "V4rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([990,522],4,0,40)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V2"
    P = ""
    Q = ""
    Vrms = "V2rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([1206,324],0,0,20)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V5"
    P = ""
    Q = ""
    Vrms = "V5rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   -Wire-([1818,846],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1818,846],0,0,-1)
    {
    Name = "V1rms"
    }
   -Wire-([1818,882],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1818,882],0,0,-1)
    {
    Name = "V2rms"
    }
   -Wire-([1818,918],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1818,918],0,0,-1)
    {
    Name = "V3rms"
    }
   -Wire-([1818,954],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1818,954],0,0,-1)
    {
    Name = "V4rms"
    }
   -Wire-([1818,990],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1818,990],0,0,-1)
    {
    Name = "V4rms"
    }
   }
  }
 }

